/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

class BattleCanvas
extends Canvas {
    public static final int STARTING = 0;
    public static final int PLACING = 1;
    public static final int PROGRESS = 2;
    public static final int WAITING_FOR_ENEMY = 3;
    public static final int SUSPENDED = 4;
    public static final int OVER = 5;
    private int currScore = 0;
    private int phase;
    private int overCounter = 0;
    private boolean currentOrientation;
    boolean o1;
    boolean o2;
    boolean o3;
    boolean o4;
    boolean o5;
    boolean e1;
    boolean e2;
    boolean e3;
    boolean e4;
    boolean e5;
    public static final int BOARD_SIZE = 10;
    public static final int SHIP_COUNT = 5;
    int[][] myBoard;
    int[][] enemyBoard;
    int[][] myCheckBoard;
    int[][] enemyCheckBoard;
    Ship[] myShips;
    Ship[] enemyShips;
    Ship currentShip;
    int placedCounter;
    int roundCount;
    boolean showSide;
    boolean winSide;
    String message;
    String overStr = "";
    private int cursorx = 5;
    private int cursory = 5;
    private boolean fire = false;
    private boolean gamea = false;
    private boolean gameb = false;
    private boolean gamec = false;
    private boolean gamed = false;
    Image logo;
    private int cell = 1;
    private int xoffs = 0;
    private int w;
    private int h;
    private int bwidth;
    private int bheight;
    private Score score;
    private Battleship battleship;
    private Display display;
    private CommandListener listener;
    private Random random;
    private Form scoreForm;
    private TextBox levelText;
    private static int wallColor = 0x7F7F7F;
    private static int groundColor = 0xFFFFFF;
    private static int packetColor = 0;
    private static int storeColor = 0;
    private static int pusherColor = 0;
    private static boolean useDottedLine = false;

    public BattleCanvas(Battleship battleship, Score s) {
        this.battleship = battleship;
        this.display = Display.getDisplay((MIDlet)battleship);
        this.score = s;
        this.myBoard = new int[10][10];
        this.enemyBoard = new int[10][10];
        this.myShips = new Ship[5];
        this.initColors();
        this.message = "";
        this.random = new Random();
        try {
            this.logo = Image.createImage((String)"/logo.png");
        }
        catch (IOException ex) {
            this.message = "logo error";
        }
    }

    public void init() {
        this.h = this.getHeight();
        this.w = this.getWidth();
        this.cell = this.w < this.h - 14 ? this.w / 11 : (this.h - 14) / 11;
        this.xoffs = (this.w - this.cell * 10) / 2;
        this.restart();
        this.repaint();
    }

    public void destroy() {
    }

    private void initColors() {
        boolean isColor = this.display.isColor();
        int numColors = this.display.numColors();
        if (isColor) {
            this.setColors(27989, 0xFFFFFF, 16739584, 11927637, 0x6D6DFF);
        } else if (numColors > 2) {
            this.setColors(0x999999, 0xFFFFFF, 0x666666, 0xBBBBBB, 0);
        } else {
            this.setColors(0x6A6A6A, 0xFFFFFF, 0x6A6A6A, 0, 0);
            useDottedLine = true;
        }
    }

    private void setColors(int w, int g, int pa, int s, int pu) {
        if (w != -1) {
            wallColor = w;
        }
        if (g != -1) {
            groundColor = g;
        }
        if (pa != -1) {
            packetColor = pa;
        }
        if (s != -1) {
            storeColor = s;
        }
        if (pu != -1) {
            pusherColor = pu;
        }
    }

    private int parseColor(String s) {
        if (s == null) {
            return -1;
        }
        return Integer.parseInt(s, 16);
    }

    public int getRandom(int range) {
        boolean loop = true;
        int retVal = 0;
        retVal = this.random.nextInt();
        if (retVal < 0) {
            retVal *= -1;
        }
        while (retVal > range) {
            retVal /= 10;
        }
        return retVal;
    }

    public void placeEnemyShips() {
        int i = 1;
        while (i <= 5) {
            boolean loop = true;
            boolean orientation = false;
            Ship ship = new Ship(i, 0, 0);
            while (loop) {
                ship.setX(this.getRandom(10));
                ship.setY(this.getRandom(10));
                orientation = this.getRandom(1) == 0;
                ship.setOrientation(orientation);
                if (ship.getType() == 5) {
                    this.e1 = orientation;
                }
                if (ship.getType() == 4) {
                    this.e2 = orientation;
                }
                if (ship.getType() == 3) {
                    this.e3 = orientation;
                }
                if (ship.getType() == 2) {
                    this.e4 = orientation;
                }
                if (ship.getType() == 1) {
                    this.e5 = orientation;
                }
                if (!this.checkShip(ship, false)) continue;
                this.addShip(ship, false);
                this.enemyShips[i - 1] = ship;
                loop = false;
            }
            ++i;
        }
    }

    public void doEnemyShot() {
        int x = 0;
        int y = 0;
        try {
            if (this.countHits(false) == this.getTotalShipPieces()) {
                this.phase = 5;
                this.winSide = false;
                return;
            }
            boolean loop = true;
            while (loop) {
                x = this.getRandom(10);
                if (this.enemyBoard[x][y = this.getRandom(10)] != 0) continue;
                this.addShot(x, y, false);
                loop = false;
            }
        }
        catch (Exception ex) {
            System.out.println("error in do enemy shot : " + x + "," + y);
        }
    }

    public boolean placeShip() {
        if (this.currentShip != null) {
            this.currentShip.setX(this.cursorx);
            this.currentShip.setY(this.cursory);
            this.currentShip.setOrientation(this.currentOrientation);
            if (!this.checkShip(this.currentShip, true)) {
                return false;
            }
            this.addShip(this.currentShip, true);
            this.myShips[this.placedCounter - 1] = this.currentShip;
        }
        this.cursorx = 5;
        this.cursory = 5;
        this.currentOrientation = false;
        ++this.placedCounter;
        if (this.placedCounter > 5) {
            return true;
        }
        this.currentShip = new Ship(this.placedCounter, 5, 5);
        this.message = "Place the " + this.currentShip.getName();
        return false;
    }

    public void addShip(Ship ship, boolean side) {
        int i;
        int j = -1;
        while (j <= ship.getLength()) {
            int k = -1;
            while (k < 2) {
                if (!ship.getOrientation()) {
                    this.addCheckField(ship.getX() + k, ship.getY() + j, side);
                } else {
                    this.addCheckField(ship.getX() + j, ship.getY() + k, side);
                }
                ++k;
            }
            ++j;
        }
        if (side) {
            i = 0;
            while (i < ship.getLength()) {
                if (!ship.getOrientation()) {
                    this.myCheckBoard[ship.getX()][ship.getY() + i] = 1;
                } else {
                    this.myCheckBoard[ship.getX() + i][ship.getY()] = 1;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < ship.getLength()) {
                if (!ship.getOrientation()) {
                    this.enemyCheckBoard[ship.getX()][ship.getY() + i] = 1;
                } else {
                    this.enemyCheckBoard[ship.getX() + i][ship.getY()] = 1;
                }
                ++i;
            }
        }
    }

    private void addCheckField(int x, int y, boolean side) {
        if (x >= 0 && x < 10 && y >= 0 && y < 10) {
            if (side) {
                this.myCheckBoard[x][y] = 2;
            } else {
                this.enemyCheckBoard[x][y] = 2;
            }
        }
    }

    private boolean checkField(int x, int y, boolean side) {
        if (x >= 0 && x < 10 && y >= 0 && y < 10) {
            if (side) {
                return this.myCheckBoard[x][y] == 0;
            }
            return this.enemyCheckBoard[x][y] == 0;
        }
        return false;
    }

    public boolean checkShip(Ship ship, boolean side) {
        int i = 0;
        while (i < ship.getLength()) {
            if (ship.getOrientation()) {
                if (!this.checkField(ship.getX() + i, ship.getY(), side)) {
                    this.message = "Can't place here";
                    return false;
                }
            } else if (!this.checkField(ship.getX(), ship.getY() + i, side)) {
                this.message = "Can't place here";
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addShot(int x, int y, boolean side) {
        if (x < 0 || y < 0 || x > 10 || y > 10) {
            return;
        }
        if (side) {
            this.myBoard[x][y] = this.enemyCheckBoard[x][y] == 1 ? 1 : 2;
        } else {
            this.enemyBoard[x][y] = this.myCheckBoard[x][y] == 1 ? 1 : 2;
        }
    }

    public int countHits(boolean side) {
        int retVal = 0;
        int i = 0;
        while (i <= 9) {
            int j = 0;
            while (j <= 9) {
                if (side) {
                    if (this.myBoard[i][j] == 1) {
                        ++retVal;
                    }
                } else if (this.enemyBoard[i][j] == 1) {
                    ++retVal;
                }
                ++j;
            }
            ++i;
        }
        return retVal;
    }

    public int getTotalShipPieces() {
        return 15;
    }

    public boolean checkHit(int x, int y, boolean side) {
        if (x < 0 || y < 0 || x > 10 || y > 10) {
            return false;
        }
        return side ? this.myCheckBoard[x][y] == 1 : this.enemyCheckBoard[x][y] == 1;
    }

    public void gameUpdate() {
        switch (this.phase) {
            case 0: {
                if (!this.fire) break;
                this.phase = 1;
                this.placeEnemyShips();
                this.placeShip();
                break;
            }
            case 1: {
                this.message = "Place the " + this.currentShip.getName();
                if (this.fire && this.placeShip()) {
                    this.phase = 2;
                    this.message = "Aim and fire";
                    this.cursorx = 5;
                    this.cursory = 5;
                }
                if (!this.gamea) break;
                boolean bl = this.currentOrientation = !this.currentOrientation;
                if (this.currentShip.getType() == 5) {
                    boolean bl2 = this.o1 = !this.o1;
                }
                if (this.currentShip.getType() == 4) {
                    boolean bl3 = this.o2 = !this.o2;
                }
                if (this.currentShip.getType() == 3) {
                    boolean bl4 = this.o3 = !this.o3;
                }
                if (this.currentShip.getType() == 2) {
                    boolean bl5 = this.o4 = !this.o4;
                }
                if (this.currentShip.getType() != 1) break;
                this.o5 = !this.o5;
                break;
            }
            case 2: {
                if (!this.showSide) {
                    this.showSide = true;
                    this.message = "Aim and fire";
                    break;
                }
                if (this.fire) {
                    ++this.roundCount;
                    this.addShot(this.cursorx, this.cursory, true);
                    if (this.countHits(true) == this.getTotalShipPieces()) {
                        this.winSide = true;
                        this.phase = 5;
                    }
                    this.message = this.checkHit(this.cursorx, this.cursory, false) ? "R : " + this.roundCount + ", Hit (" + this.countHits(true) + "/" + this.getTotalShipPieces() + ")" : "R : " + this.roundCount + ", Miss";
                    this.doEnemyShot();
                } else {
                    this.message = "Aim and fire";
                }
                if (!this.gameb) break;
                this.showSide = false;
                this.message = "Enemy view";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                ++this.overCounter;
                if (this.overCounter != 3) break;
                this.overCounter = 0;
            }
        }
        this.fire = false;
        this.gamea = false;
        this.gameb = false;
        this.gamec = false;
        this.gamed = false;
    }

    public Screen getScoreScreen() {
        Form scoreForm = null;
        int bestScore = this.score.getScore();
        boolean newbest = this.phase == 5 && (bestScore == 0 || this.currScore < bestScore);
        scoreForm = new Form(null);
        scoreForm.append((Item)new StringItem(newbest ? "New Best:\n" : "Current:\n", this.currScore + " moves"));
        scoreForm.append((Item)new StringItem(newbest ? "Old Best:\n" : "Best:\n", bestScore + " moves"));
        String title = "Scores";
        if (newbest) {
            title = "Congratulations";
        }
        scoreForm.setTitle(title);
        return scoreForm;
    }

    protected void keyRepeated(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.keyPressed(keyCode);
                break;
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        boolean move = false;
        switch (action) {
            case 5: {
                if (this.cursorx >= 9) break;
                ++this.cursorx;
                break;
            }
            case 2: {
                if (this.cursorx <= 0) break;
                --this.cursorx;
                break;
            }
            case 6: {
                if (this.cursory >= 9) break;
                ++this.cursory;
                break;
            }
            case 1: {
                if (this.cursory <= 0) break;
                --this.cursory;
                break;
            }
            case 8: {
                this.fire = true;
                break;
            }
            case 9: {
                this.gamea = true;
                break;
            }
            case 10: {
                this.gameb = true;
                break;
            }
            case 11: {
                this.gamec = true;
                break;
            }
            case 12: {
                this.gamed = true;
                break;
            }
            default: {
                return;
            }
        }
        this.gameUpdate();
        this.repaint();
    }

    public void restart() {
        this.myBoard = new int[10][10];
        this.enemyBoard = new int[10][10];
        this.myCheckBoard = new int[10][10];
        this.enemyCheckBoard = new int[10][10];
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                this.myBoard[i][j] = 0;
                this.enemyBoard[i][j] = 0;
                this.myCheckBoard[i][j] = 0;
                this.enemyCheckBoard[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.myShips = new Ship[5];
        this.enemyShips = new Ship[5];
        this.placedCounter = 0;
        this.roundCount = 0;
        this.overCounter = 0;
        this.showSide = true;
        this.phase = 0;
    }

    private void updateScores() {
    }

    public void setCommandListener(CommandListener l) {
        super.setCommandListener(l);
        this.listener = l;
    }

    private void paintLogo(Graphics g) {
        g.setColor(groundColor);
        g.fillRect(0, 0, this.w, this.h);
        if (this.logo != null) {
            g.drawImage(this.logo, (this.w - 80) / 2, 0, 20);
        }
        g.setColor(wallColor);
        if (this.h > 62) {
            g.drawString("Press Fire to Start", (this.w - g.getFont().stringWidth("Press Fire to Start")) / 2, this.h - 14, 20);
        }
    }

    private void paintGrid(Graphics g) {
        g.setColor(groundColor);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(wallColor);
        int i = 0;
        while (i < 11) {
            g.drawLine(i * this.cell + this.xoffs, 0, i * this.cell + this.xoffs, 10 * this.cell);
            ++i;
        }
        int j = 0;
        while (j < 11) {
            g.drawLine(this.xoffs, j * this.cell, this.xoffs + 10 * this.cell, j * this.cell);
            ++j;
        }
    }

    private void paintHits(Graphics g, boolean side) {
        int i = 0;
        while (i <= 9) {
            int j = 0;
            while (j <= 9) {
                if (side) {
                    if (this.myBoard[i][j] == 1) {
                        g.setColor(packetColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                    if (this.myBoard[i][j] == 2) {
                        g.setColor(wallColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                } else {
                    if (this.enemyBoard[i][j] == 1) {
                        g.setColor(packetColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                    if (this.enemyBoard[i][j] == 2) {
                        g.setColor(wallColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void paintCheck(Graphics g, boolean side) {
        int i = 0;
        while (i <= 9) {
            int j = 0;
            while (j <= 9) {
                if (side) {
                    if (this.myCheckBoard[i][j] == 1) {
                        g.setColor(packetColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                    if (this.myCheckBoard[i][j] == 2) {
                        g.setColor(wallColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                } else {
                    if (this.enemyCheckBoard[i][j] == 1) {
                        g.setColor(packetColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                    if (this.enemyCheckBoard[i][j] == 2) {
                        g.setColor(wallColor);
                        g.fillRect(this.xoffs + 1 + i * this.cell, 1 + j * this.cell, this.cell - 1, this.cell - 1);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void paintCursor(Graphics g) {
        g.setColor(pusherColor);
        g.fillRect(this.xoffs + 1 + this.cursorx * this.cell, 1 + this.cursory * this.cell, this.cell - 1, this.cell - 1);
    }

    private void paintPlacingShip(Graphics g) {
        if (this.currentShip == null) {
            return;
        }
        g.setColor(pusherColor);
        int max = this.currentShip.getLength();
        int i = 0;
        while (i < max) {
            if (this.currentOrientation) {
                if (i + this.cursorx < 10) {
                    g.fillRect(this.xoffs + 1 + (this.cursorx + i) * this.cell, 1 + this.cursory * this.cell, this.cell - 1, this.cell - 1);
                }
            } else if (i + this.cursory < 10) {
                g.fillRect(this.xoffs + 1 + this.cursorx * this.cell, 1 + (this.cursory + i) * this.cell, this.cell - 1, this.cell - 1);
            }
            ++i;
        }
    }

    private void paintShip(Graphics g, Ship ship, boolean side) {
        if (ship == null) {
            return;
        }
        g.setColor(packetColor);
        int max = ship.getLength();
        boolean orientation = false;
        int i = 0;
        while (i < max) {
            if (side) {
                if (ship.getType() == 5) {
                    orientation = this.o1;
                }
                if (ship.getType() == 4) {
                    orientation = this.o2;
                }
                if (ship.getType() == 3) {
                    orientation = this.o3;
                }
                if (ship.getType() == 2) {
                    orientation = this.o4;
                }
                if (ship.getType() == 1) {
                    orientation = this.o5;
                }
            } else {
                if (ship.getType() == 5) {
                    orientation = this.e1;
                }
                if (ship.getType() == 4) {
                    orientation = this.e2;
                }
                if (ship.getType() == 3) {
                    orientation = this.e3;
                }
                if (ship.getType() == 2) {
                    orientation = this.e4;
                }
                if (ship.getType() == 1) {
                    orientation = this.e5;
                }
            }
            if (orientation) {
                g.fillRect(this.xoffs + 1 + (ship.getX() + i) * this.cell, 1 + ship.getY() * this.cell, this.cell - 1, this.cell - 1);
            } else {
                g.fillRect(this.xoffs + 1 + ship.getX() * this.cell, 1 + (ship.getY() + i) * this.cell, this.cell - 1, this.cell - 1);
            }
            ++i;
        }
    }

    private void paintShips(Graphics g, boolean side) {
        int i = 0;
        while (i < 5) {
            Ship ship = null;
            ship = side ? this.myShips[i] : this.enemyShips[i];
            if (ship != null) {
                this.paintShip(g, ship, side);
            }
            ++i;
        }
    }

    protected void paint(Graphics g) {
        int x = 0;
        int y = 0;
        int x2 = this.bwidth;
        int y2 = this.bheight;
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        x = clipx / this.cell;
        y = clipy / this.cell;
        x2 = (clipx + clipw + this.cell - 1) / this.cell;
        y2 = (clipy + cliph + this.cell - 1) / this.cell;
        if (x2 > this.bwidth) {
            x2 = this.bwidth;
        }
        if (y2 > this.bheight) {
            y2 = this.bheight;
        }
        switch (this.phase) {
            case 0: {
                this.paintLogo(g);
                break;
            }
            case 1: {
                this.paintGrid(g);
                this.paintShips(g, true);
                this.paintPlacingShip(g);
                break;
            }
            case 2: {
                this.paintGrid(g);
                if (this.showSide) {
                    this.paintHits(g, true);
                    this.paintCursor(g);
                    break;
                }
                this.paintHits(g, false);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (this.overCounter == 0) {
                    g.setColor(pusherColor);
                    this.overStr = "Game Over.";
                    g.drawString(this.overStr, (this.w - g.getFont().stringWidth(this.overStr)) / 2, this.h / 2 - 15, 20);
                    this.overStr = this.winSide ? "You won" : "Enemy won";
                    g.drawString(this.overStr, (this.w - g.getFont().stringWidth(this.overStr)) / 2, this.h / 2 + 15, 20);
                    break;
                }
                this.paintGrid(g);
                if (this.overCounter == 1) {
                    this.paintShips(g, true);
                    this.paintHits(g, true);
                    this.message = "Your view";
                    break;
                }
                this.paintShips(g, false);
                this.paintHits(g, false);
                this.message = "Enemy view";
            }
        }
        g.setColor(pusherColor);
        g.drawString(this.message, 0, this.h - 14, 20);
    }
}

